/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.tableau.hyperapi.Connection;
import com.tableau.hyperapi.HyperAPI;
import com.tableau.hyperapi.HyperBinary;
import com.tableau.hyperapi.HyperException;
import com.tableau.hyperapi.Interval;
import com.tableau.hyperapi.Name;
import com.tableau.hyperapi.ResultSchema;
import com.tableau.hyperapi.SqlType;
import com.tableau.hyperapi.TypeTag;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.OptionalLong;

public final class Result
implements AutoCloseable {
    private final Charset UTF8_CharSET = Charset.forName("UTF-8");
    private Connection connection;
    private Pointer rowsetHandle;
    private ResultSchema schema;
    private OptionalLong affectedRowCount = OptionalLong.empty();
    private Chunk currentChunk;
    private static ZoneId utcTimeZone = ZoneId.of("UTC");

    Result(Connection connection, Pointer rowsetHandle) {
        this.connection = connection;
        this.rowsetHandle = rowsetHandle;
        this.schema = new ResultSchema(HyperAPI.hyper_rowset_get_table_definition(rowsetHandle));
        int affectedRowCount = (int)HyperAPI.hyper_rowset_get_affected_row_count(rowsetHandle);
        if (affectedRowCount >= 0) {
            this.affectedRowCount = OptionalLong.of(affectedRowCount);
        }
    }

    static String getMatchingGetMethodName(TypeTag type) {
        switch (type) {
            case BOOL: {
                return "getBool";
            }
            case BIG_INT: {
                return "getLong";
            }
            case SMALL_INT: {
                return "getShort";
            }
            case OID: 
            case INT: {
                return "getInt";
            }
            case NUMERIC: {
                return "getBigDecimal";
            }
            case FLOAT: {
                return "getFloat";
            }
            case DOUBLE: {
                return "getDouble";
            }
            case BYTES: 
            case GEOGRAPHY: {
                return "getByteArray";
            }
            case TEXT: 
            case VARCHAR: 
            case CHAR: 
            case JSON: {
                return "getString";
            }
            case DATE: {
                return "getLocalDate";
            }
            case INTERVAL: {
                return "getInterval";
            }
            case TIME: {
                return "getLocalTime";
            }
            case TIMESTAMP: {
                return "getLocalDateTime";
            }
            case TIMESTAMP_TZ: {
                return "getOffsetDateTime";
            }
        }
        return "getRaw";
    }

    protected void finalize() {
        if (this.rowsetHandle != null) {
            System.err.println("ERROR: Result.finalize called with an existing result handle. Call close() or use try-with-resources.");
        }
    }

    @Override
    public void close() {
        this.closeCurrentChunk();
        this.closeRowset();
    }

    public boolean isOpen() {
        return this.rowsetHandle != null;
    }

    private void throwIfClosed() {
        if (!this.isOpen()) {
            throw new InternalError("The result object is closed.");
        }
    }

    public ResultSchema getSchema() {
        return this.schema;
    }

    public OptionalLong getAffectedRowCount() {
        return this.affectedRowCount;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean nextRow() {
        if (!this.isOpen()) {
            return false;
        }
        if (this.currentChunk != null && this.currentChunk.nextRow()) {
            return true;
        }
        this.currentChunk = this.nextChunk();
        if (this.currentChunk == null) {
            return false;
        }
        return this.nextRow();
    }

    public boolean isNull(int position) {
        return this.currentChunk.isNull(position);
    }

    private Pointer getValue(int position, int expectedSize, SizeByRef sizeByRef) {
        return this.currentChunk.getValue(position, expectedSize, sizeByRef);
    }

    private Pointer getValue(int position, int expectedSize) {
        return this.getValue(position, expectedSize, null);
    }

    private IllegalStateException formatTypeViolationException(String methodName, SqlType actualType, Name columnName) {
        return new IllegalStateException("\"" + methodName + "\" cannot be used for column \"" + columnName.getUnescaped() + "\" which is of type " + actualType + ".'" + Result.getMatchingGetMethodName(actualType.getTag()) + "()' could be used to read this column.");
    }

    public short getShort(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        if (sqlType.getTag() == TypeTag.SMALL_INT) {
            return this.getValue(position, 2).getShort(0L);
        }
        throw this.formatTypeViolationException("getShort", sqlType, c.getName());
    }

    public int getInt(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        switch (sqlType.getTag()) {
            case OID: 
            case INT: {
                return this.getValue(position, 4).getInt(0L);
            }
            case SMALL_INT: {
                return this.getValue(position, 2).getShort(0L);
            }
        }
        throw this.formatTypeViolationException("getInt", sqlType, c.getName());
    }

    public long getLong(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        switch (sqlType.getTag()) {
            case OID: 
            case INT: {
                return this.getValue(position, 4).getInt(0L);
            }
            case SMALL_INT: {
                return this.getValue(position, 2).getShort(0L);
            }
            case BIG_INT: {
                return this.getValue(position, 8).getLong(0L);
            }
            case NUMERIC: {
                return this.getNumeric(position).longValue();
            }
        }
        throw this.formatTypeViolationException("getLong", sqlType, c.getName());
    }

    public float getFloat(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        switch (sqlType.getTag()) {
            case BIG_INT: {
                return this.getValue(position, 8).getLong(0L);
            }
            case INT: {
                return this.getValue(position, 4).getInt(0L);
            }
            case SMALL_INT: {
                return this.getValue(position, 2).getShort(0L);
            }
            case FLOAT: {
                return this.getValue(position, 4).getFloat(0L);
            }
            case DOUBLE: {
                return (float)this.getValue(position, 8).getDouble(0L);
            }
            case NUMERIC: {
                return this.getNumeric(position).floatValue();
            }
        }
        throw this.formatTypeViolationException("getFloat", sqlType, c.getName());
    }

    public double getDouble(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        switch (sqlType.getTag()) {
            case BIG_INT: {
                return this.getValue(position, 8).getLong(0L);
            }
            case INT: {
                return this.getValue(position, 4).getInt(0L);
            }
            case SMALL_INT: {
                return this.getValue(position, 2).getShort(0L);
            }
            case FLOAT: {
                return this.getValue(position, 4).getFloat(0L);
            }
            case DOUBLE: {
                return this.getValue(position, 8).getDouble(0L);
            }
            case NUMERIC: {
                return this.getNumeric(position).doubleValue();
            }
        }
        throw this.formatTypeViolationException("getDouble", sqlType, c.getName());
    }

    public String getString(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        switch (sqlType.getTag()) {
            case TEXT: 
            case VARCHAR: 
            case CHAR: 
            case JSON: {
                SizeByRef sizeByRef = new SizeByRef();
                byte[] bb = this.getValue(position, 0, sizeByRef).getByteArray(0L, sizeByRef.size);
                return new String(bb, this.UTF8_CharSET);
            }
        }
        throw this.formatTypeViolationException("getString", sqlType, c.getName());
    }

    public boolean getBool(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        if (sqlType.getTag() == TypeTag.BOOL) {
            return this.getValue(position, 1).getByte(0L) != 0;
        }
        throw this.formatTypeViolationException("getBool", sqlType, c.getName());
    }

    public BigDecimal getBigDecimal(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        switch (sqlType.getTag()) {
            case NUMERIC: {
                return this.getNumeric(position);
            }
            case BIG_INT: {
                return BigDecimal.valueOf(this.getValue(position, 8).getLong(0L));
            }
            case OID: 
            case INT: {
                return BigDecimal.valueOf(this.getValue(position, 4).getInt(0L));
            }
            case SMALL_INT: {
                return BigDecimal.valueOf(this.getValue(position, 2).getShort(0L));
            }
        }
        throw this.formatTypeViolationException("getBigDecimal", sqlType, c.getName());
    }

    public byte[] getByteArray(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        switch (sqlType.getTag()) {
            case BYTES: 
            case GEOGRAPHY: {
                SizeByRef sizeByRef = new SizeByRef();
                return this.getValue(position, 0, sizeByRef).getByteArray(0L, sizeByRef.size);
            }
        }
        throw this.formatTypeViolationException("getByteArray", sqlType, c.getName());
    }

    public LocalDate getLocalDate(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        if (sqlType.getTag() == TypeTag.DATE) {
            return HyperBinary.getLocalDate(this.getValue(position, 4).getInt(0L));
        }
        throw this.formatTypeViolationException("getLocalDate", sqlType, c.getName());
    }

    public Interval getInterval(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        if (sqlType.getTag() == TypeTag.INTERVAL) {
            long[] raw = this.getValue(position, 16).getLongArray(0L, 2);
            return new Interval(new Interval.RawInterval(raw[0], raw[1]));
        }
        throw this.formatTypeViolationException("getInterval", sqlType, c.getName());
    }

    public LocalTime getLocalTime(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        if (sqlType.getTag() == TypeTag.TIME) {
            return HyperBinary.getLocalTime(this.getValue(position, 8).getLong(0L));
        }
        throw this.formatTypeViolationException("getLocalTime", sqlType, c.getName());
    }

    public LocalDateTime getLocalDateTime(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        if (sqlType.getTag() == TypeTag.TIMESTAMP) {
            return HyperBinary.getLocalDateTime(this.getValue(position, 8).getLong(0L));
        }
        throw this.formatTypeViolationException("getLocalDateTime", sqlType, c.getName());
    }

    public ZonedDateTime getZonedDateTime(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        if (sqlType.getTag() == TypeTag.TIMESTAMP_TZ) {
            LocalDateTime value = HyperBinary.getLocalDateTime(this.getValue(position, 8).getLong(0L));
            return value.atZone(utcTimeZone);
        }
        throw this.formatTypeViolationException("getZonedDateTime", sqlType, c.getName());
    }

    public OffsetDateTime getOffsetDateTime(int position) {
        ResultSchema.Column c = this.schema.getColumn(position);
        SqlType sqlType = c.getType();
        if (sqlType.getTag() == TypeTag.TIMESTAMP_TZ) {
            LocalDateTime value = HyperBinary.getLocalDateTime(this.getValue(position, 8).getLong(0L));
            return value.atZone(utcTimeZone).toOffsetDateTime();
        }
        throw this.formatTypeViolationException("getOffsetDateTime", sqlType, c.getName());
    }

    public byte[] getRaw(int position) {
        SizeByRef sizeByRef = new SizeByRef();
        return this.currentChunk.getValue(position, 0, sizeByRef).getByteArray(0L, sizeByRef.size);
    }

    public Object getObject(int position) {
        Object result;
        switch (this.schema.getColumn(position).getTypeTag()) {
            case BOOL: {
                result = this.getBool(position);
                break;
            }
            case BIG_INT: {
                result = this.getLong(position);
                break;
            }
            case SMALL_INT: {
                result = this.getShort(position);
                break;
            }
            case OID: 
            case INT: {
                result = this.getInt(position);
                break;
            }
            case NUMERIC: {
                result = this.getBigDecimal(position);
                break;
            }
            case FLOAT: {
                result = Float.valueOf(this.getFloat(position));
                break;
            }
            case DOUBLE: {
                result = this.getDouble(position);
                break;
            }
            case BYTES: 
            case GEOGRAPHY: {
                result = this.getByteArray(position);
                break;
            }
            case TEXT: 
            case VARCHAR: 
            case CHAR: 
            case JSON: {
                result = this.getString(position);
                break;
            }
            case DATE: {
                result = this.getLocalDate(position);
                break;
            }
            case INTERVAL: {
                result = this.getInterval(position);
                break;
            }
            case TIME: {
                result = this.getLocalTime(position);
                break;
            }
            case TIMESTAMP: {
                result = this.getLocalDateTime(position);
                break;
            }
            case TIMESTAMP_TZ: {
                result = this.getOffsetDateTime(position);
                break;
            }
            case UNSUPPORTED: {
                result = this.getRaw(position);
                break;
            }
            default: {
                throw new HyperException("Unsupported type '" + (Object)((Object)this.schema.getColumn(position).getTypeTag()) + "'.", "See supported types in the API documentation.", null, new HyperException.ContextId(-1912635560));
            }
        }
        return result;
    }

    private BigDecimal getNumeric(int position) {
        SqlType type = this.schema.getColumn(position).getType();
        int precision = type.getPrecision().orElseThrow(() -> new InternalError("Numeric column without precision."));
        int scale = type.getScale().orElseThrow(() -> new InternalError("Numeric column without scale."));
        if (precision <= 18) {
            long value = this.getValue(position, 8).getLong(0L);
            return BigDecimal.valueOf(value, scale);
        }
        byte[] raw = this.getValue(position, 16).getByteArray(0L, 16);
        for (int i = 0; i < 8; ++i) {
            byte swap = raw[15 - i];
            raw[15 - i] = raw[i];
            raw[i] = swap;
        }
        return new BigDecimal(new BigInteger(raw), scale);
    }

    private Chunk nextChunk() {
        this.throwIfClosed();
        this.closeCurrentChunk();
        PointerByReference chunkByRef = new PointerByReference();
        Pointer chunkError = HyperAPI.hyper_rowset_get_next_chunk(this.rowsetHandle, chunkByRef);
        if (chunkError != null) {
            throw new HyperException(chunkError);
        }
        Pointer chunkHandle = chunkByRef.getValue();
        if (chunkHandle != null) {
            return new Chunk(chunkHandle);
        }
        this.closeRowset();
        return null;
    }

    private void closeRowset() {
        if (this.rowsetHandle != null) {
            HyperAPI.hyper_close_rowset(this.rowsetHandle);
            this.rowsetHandle = null;
            this.schema = null;
        }
    }

    private void closeCurrentChunk() {
        if (this.currentChunk != null) {
            this.currentChunk.close();
        }
    }

    private void throwIfInvalidBinary(int position, int expectedSize, int actualSize) {
        if (actualSize != expectedSize) {
            this.throwIfNull(position);
            throw new HyperException("Invalid binary data for column " + this.schema.getColumn(position).getName() + ": Binary data has the wrong size.", "", null, new HyperException.ContextId(1605147143));
        }
    }

    private void throwIfNull(int position) {
        if (this.isNull(position)) {
            throw new IllegalStateException("Value is null for column \"" + this.schema.getColumn(position).getName().getUnescaped() + "\": Cannot call getXXXX for a column value that is null: Call isNull() first.");
        }
    }

    private class Chunk {
        private Pointer handle;
        private int rowCount = 0;
        private int columnCount = 0;
        private int rowOffset = -1;
        private Pointer[] values = null;
        private long[] valueSizes = null;

        Chunk(Pointer handle) {
            this.handle = handle;
            LongByReference columnCountByRef = new LongByReference();
            LongByReference rowCountByRef = new LongByReference();
            PointerByReference valuesByRef = new PointerByReference();
            PointerByReference valueSizesByRef = new PointerByReference();
            HyperAPI.hyper_rowset_chunk_field_values(handle, columnCountByRef, rowCountByRef, valuesByRef, valueSizesByRef);
            this.rowCount = (int)rowCountByRef.getValue();
            this.columnCount = (int)columnCountByRef.getValue();
            int fieldCount = this.rowCount * this.columnCount;
            if (fieldCount > 0) {
                this.values = valuesByRef.getValue().getPointerArray(0L, fieldCount);
                this.valueSizes = valueSizesByRef.getValue().getLongArray(0L, fieldCount);
            }
        }

        boolean nextRow() {
            return this.rowOffset++ + 1 < this.rowCount;
        }

        boolean isNull(int position) {
            return this.values[this.rowOffset * this.columnCount + position] == null;
        }

        Pointer getValue(int position, int expectedSize, SizeByRef sizeByRef) {
            int offset = this.rowOffset * this.columnCount + position;
            Pointer value = this.values[offset];
            int size = (int)this.valueSizes[offset];
            if (expectedSize != 0) {
                Result.this.throwIfInvalidBinary(position, expectedSize, size);
            }
            if (sizeByRef != null) {
                sizeByRef.size = size;
            }
            return value;
        }

        void close() {
            HyperAPI.hyper_destroy_rowset_chunk(this.handle);
        }
    }

    private class SizeByRef {
        public int size;

        private SizeByRef() {
        }
    }
}

