/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import java.util.HashMap;
import java.util.Map;

public enum TypeTag {
    UNSUPPORTED(0),
    BOOL(1),
    BIG_INT(2),
    SMALL_INT(3),
    INT(4),
    NUMERIC(5),
    DOUBLE(6),
    OID(7),
    BYTES(8),
    TEXT(9),
    VARCHAR(10),
    CHAR(11),
    JSON(12),
    DATE(13),
    INTERVAL(14),
    TIME(15),
    TIMESTAMP(16),
    TIMESTAMP_TZ(17),
    TABGEOGRAPHY(18),
    GEOGRAPHY(18),
    FLOAT(19);

    private static final Map<Integer, TypeTag> map;
    private final int value;

    private static Map<Integer, TypeTag> buildMap() {
        HashMap<Integer, TypeTag> map = new HashMap<Integer, TypeTag>();
        for (TypeTag type : TypeTag.values()) {
            map.put(type.value, type);
        }
        return map;
    }

    private TypeTag(int value) {
        this.value = value;
    }

    static TypeTag valueOf(int value) {
        return map.get(value);
    }

    int getValue() {
        return this.value;
    }

    static {
        map = TypeTag.buildMap();
    }
}

