/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Pointer;
import com.tableau.hyperapi.HyperAPI;
import com.tableau.hyperapi.NativeHandleHelpers;
import com.tableau.hyperapi.TypeTag;
import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;

public final class SqlType
implements Comparable<SqlType> {
    static int HYPER_UNUSED_MODIFIER = -1;
    static int HYPER_BOOL_OID = 16;
    static int HYPER_BIG_INT_OID = 20;
    static int HYPER_SMALL_INT_OID = 21;
    static int HYPER_INT_OID = 23;
    static int HYPER_NUMERIC_OID = 1700;
    static int HYPER_FLOAT_OID = 700;
    static int HYPER_DOUBLE_OID = 701;
    static int HYPER_OID_OID = 26;
    static int HYPER_BYTES_OID = 17;
    static int HYPER_TEXT_OID = 25;
    static int HYPER_VARCHAR_OID = 1043;
    static int HYPER_CHAR1_OID = 18;
    static int HYPER_CHAR_OID = 1042;
    static int HYPER_JSON_OID = 114;
    static int HYPER_DATE_OID = 1082;
    static int HYPER_INTERVAL_OID = 1186;
    static int HYPER_TIME_OID = 1083;
    static int HYPER_TIMESTAMP_OID = 1114;
    static int HYPER_TIMESTAMP_TZ_OID = 1184;
    static int HYPER_TABGEOGRAPHY_OID = 5003;
    static int HYPER_GEOGRAPHY_OID = 5003;
    private TypeTag tag;
    private int oid;
    private int modifier;

    SqlType(TypeTag tag, int oid, int modifier) {
        this.tag = tag;
        this.oid = oid;
        this.modifier = modifier;
    }

    SqlType(Pointer handle, int position) {
        NativeHandleHelpers.checkHandleNotNull(handle);
        this.tag = TypeTag.valueOf(HyperAPI.hyper_table_definition_column_type_tag(handle, position));
        this.oid = HyperAPI.hyper_table_definition_column_type_oid(handle, position);
        this.modifier = HyperAPI.hyper_table_definition_column_type_modifier(handle, position);
    }

    SqlType(TypeTag tag, int oid) {
        this(tag, oid, HYPER_UNUSED_MODIFIER);
    }

    public static SqlType bool() {
        return new SqlType(TypeTag.BOOL, HYPER_BOOL_OID);
    }

    public static SqlType bigInt() {
        return new SqlType(TypeTag.BIG_INT, HYPER_BIG_INT_OID);
    }

    public static SqlType smallInt() {
        return new SqlType(TypeTag.SMALL_INT, HYPER_SMALL_INT_OID);
    }

    public static SqlType integer() {
        return new SqlType(TypeTag.INT, HYPER_INT_OID);
    }

    public static SqlType numeric(int precision, int scale) {
        return new SqlType(TypeTag.NUMERIC, HYPER_NUMERIC_OID, HyperAPI.hyper_encode_numeric_modifier(precision, scale));
    }

    public static SqlType real() {
        return new SqlType(TypeTag.FLOAT, HYPER_FLOAT_OID);
    }

    public static SqlType doublePrecision() {
        return new SqlType(TypeTag.DOUBLE, HYPER_DOUBLE_OID);
    }

    public static SqlType oid() {
        return new SqlType(TypeTag.OID, HYPER_OID_OID);
    }

    public static SqlType bytes() {
        return new SqlType(TypeTag.BYTES, HYPER_BYTES_OID);
    }

    public static SqlType text() {
        return new SqlType(TypeTag.TEXT, HYPER_TEXT_OID);
    }

    public static SqlType varchar(int maxLength) {
        return new SqlType(TypeTag.VARCHAR, HYPER_VARCHAR_OID, HyperAPI.hyper_encode_string_modifier(maxLength));
    }

    public static SqlType character(int maxLength) {
        return new SqlType(TypeTag.CHAR, maxLength == 1 ? HYPER_CHAR1_OID : HYPER_CHAR_OID, HyperAPI.hyper_encode_string_modifier(maxLength));
    }

    public static SqlType json() {
        return new SqlType(TypeTag.JSON, HYPER_JSON_OID);
    }

    public static SqlType date() {
        return new SqlType(TypeTag.DATE, HYPER_DATE_OID);
    }

    public static SqlType interval() {
        return new SqlType(TypeTag.INTERVAL, HYPER_INTERVAL_OID);
    }

    public static SqlType time() {
        return new SqlType(TypeTag.TIME, HYPER_TIME_OID);
    }

    public static SqlType timestamp() {
        return new SqlType(TypeTag.TIMESTAMP, HYPER_TIMESTAMP_OID);
    }

    public static SqlType timestampTz() {
        return new SqlType(TypeTag.TIMESTAMP_TZ, HYPER_TIMESTAMP_TZ_OID);
    }

    public static SqlType tabgeography() {
        return new SqlType(TypeTag.TABGEOGRAPHY, HYPER_TABGEOGRAPHY_OID);
    }

    public static SqlType geography() {
        return new SqlType(TypeTag.GEOGRAPHY, HYPER_GEOGRAPHY_OID);
    }

    public TypeTag getTag() {
        return this.tag;
    }

    public int getInternalOid() {
        return this.oid;
    }

    public OptionalInt getInternalTypeModifier() {
        if (this.modifier == -1) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.modifier);
    }

    public OptionalInt getPrecision() {
        if (this.tag == TypeTag.NUMERIC) {
            return OptionalInt.of(HyperAPI.hyper_get_precision_from_modifier(this.modifier));
        }
        return OptionalInt.empty();
    }

    public OptionalInt getScale() {
        if (this.tag == TypeTag.NUMERIC) {
            return OptionalInt.of(HyperAPI.hyper_get_scale_from_modifier(this.modifier));
        }
        return OptionalInt.empty();
    }

    public OptionalInt getMaxLength() {
        if (this.tag == TypeTag.CHAR || this.tag == TypeTag.VARCHAR) {
            return OptionalInt.of(HyperAPI.hyper_get_max_length_from_modifier(this.modifier));
        }
        return OptionalInt.empty();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof SqlType) {
            SqlType other = (SqlType)that;
            return this.tag.getValue() == other.tag.getValue() && this.oid == other.oid && this.modifier == other.modifier;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.tag.getValue(), this.oid, this.modifier);
    }

    @Override
    public int compareTo(SqlType other) {
        return Comparator.comparing(type -> type.tag.getValue()).thenComparing(type -> type.modifier).thenComparing(type -> type.oid).compare(this, other);
    }

    public String toString() {
        if (this.tag == TypeTag.CHAR || this.tag == TypeTag.VARCHAR) {
            return this.tag.toString() + '(' + this.getMaxLength().orElse(0) + ')';
        }
        if (this.tag == TypeTag.NUMERIC) {
            return this.tag.toString() + '(' + this.getPrecision().orElse(0) + ", " + this.getScale().orElse(0) + ')';
        }
        if (this.tag == TypeTag.TABGEOGRAPHY || this.tag == TypeTag.GEOGRAPHY) {
            return "TABLEAU.TABGEOGRAPHY";
        }
        return this.tag.toString();
    }
}

