/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import com.tableau.hyperapi.Connection;
import com.tableau.hyperapi.HyperAPI;
import com.tableau.hyperapi.HyperBinary;
import com.tableau.hyperapi.HyperException;
import com.tableau.hyperapi.Interval;
import com.tableau.hyperapi.Name;
import com.tableau.hyperapi.NativeHandleHelpers;
import com.tableau.hyperapi.Nullability;
import com.tableau.hyperapi.SqlType;
import com.tableau.hyperapi.TableDefinition;
import com.tableau.hyperapi.TableName;
import com.tableau.hyperapi.TypeTag;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Inserter
implements AutoCloseable {
    private TableDefinition tableDefinition;
    private TableDefinition streamDefinition;
    private Pointer tableDefHandle;
    private Pointer streamDefHandle;
    private Pointer inserterHandle;
    private Pointer chunkHandle;
    private Pointer chunkData;
    private long chunkHeaderSize;
    private ByteBuffer chunkBuffer;
    private int currentColumn = 0;
    private int currentRowOffset = 0;
    private int chunkRows = 0;
    private String selectList;
    private static ZoneId utcTimeZone = ZoneId.of("UTC");

    public Inserter(Connection connection, TableName name) {
        this(connection, connection.getCatalog().getTableDefinition(name));
    }

    public Inserter(Connection connection, TableName name, String[] columns) {
        this(connection, connection.getCatalog().getTableDefinition(name), columns);
    }

    public Inserter(Connection connection, TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
        this.streamDefinition = tableDefinition;
        this.tableDefHandle = tableDefinition.createNativeTableDefinition();
        this.streamDefHandle = this.streamDefinition.createNativeTableDefinition();
        this.createNativeInserterAndChunk(connection);
        this.selectList = this.streamDefinition.getColumns().stream().map(i -> i.getName().toString()).collect(Collectors.joining(", "));
    }

    public Inserter(Connection connection, TableDefinition tableDefinition, String[] columns) {
        this(connection, tableDefinition.getSubset(columns));
    }

    public Inserter(Connection connection, TableName name, List<ColumnMapping> columnMappings, List<TableDefinition.Column> inserterDefinition) {
        this(connection, connection.getCatalog().getTableDefinition(name), columnMappings, inserterDefinition);
    }

    public Inserter(Connection connection, TableDefinition tableDefinition, List<ColumnMapping> columnMappings, List<TableDefinition.Column> inserterDefinition) {
        if (columnMappings.isEmpty()) {
            throw new IllegalArgumentException("ColumnMappings cannot be empty");
        }
        this.streamDefinition = new TableDefinition(tableDefinition.getTableName(), inserterDefinition, tableDefinition.getPersistence());
        this.streamDefHandle = this.streamDefinition.createNativeTableDefinition();
        this.tableDefinition = tableDefinition.getSubset(columnMappings);
        this.tableDefHandle = tableDefinition.createNativeTableDefinition();
        int i = 0;
        for (ColumnMapping columnMapping : columnMappings) {
            if (!columnMapping.getExpression().isPresent()) {
                TableDefinition.Column inserterColumn = this.streamDefinition.getColumnByName(columnMapping.getColumnName()).orElseThrow(() -> new IllegalArgumentException("ColumnMapping " + columnMapping.getColumnName() + " must contain an expression or defined in the inserter definition"));
                TableDefinition.Column targetColumn = this.tableDefinition.getColumn(i);
                if (!targetColumn.getType().getTag().equals((Object)inserterColumn.getType().getTag()) || !targetColumn.getNullability().equals((Object)inserterColumn.getNullability())) {
                    throw new IllegalArgumentException("Column definition for " + columnMapping.getColumnName() + " does not match the definition provided in the inserter definition");
                }
            }
            ++i;
        }
        this.createNativeInserterAndChunk(connection);
        this.selectList = columnMappings.stream().map(c -> ((ColumnMapping)c).asSelectListExpression()).collect(Collectors.joining(", "));
        Pointer expressionInserterError = HyperAPI.hyper_init_bulk_insert(this.inserterHandle, this.streamDefHandle, this.selectList);
        this.throwNativeErrorAndClose(expressionInserterError);
    }

    private void createNativeInserterAndChunk(Connection connection) {
        PointerByReference inserterByRef = new PointerByReference();
        Pointer error = HyperAPI.hyper_create_inserter(connection.handle(), this.tableDefHandle, inserterByRef);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
        this.inserterHandle = inserterByRef.getValue();
        assert (this.inserterHandle != null);
        this.chunkHandle = HyperAPI.hyper_create_data_chunk();
        this.chunkData = HyperAPI.hyper_get_chunk_data(this.chunkHandle);
        this.chunkHeaderSize = HyperAPI.hyper_get_chunk_header_size(this.chunkHandle);
        long chunkDataSize = HyperAPI.hyper_get_chunk_data_size(this.chunkHandle);
        this.chunkBuffer = this.chunkData.getByteBuffer(this.chunkHeaderSize, chunkDataSize - this.chunkHeaderSize);
    }

    static String getMatchingAddMethodName(TypeTag type) {
        switch (type) {
            case BOOL: {
                return "add(boolean)";
            }
            case BIG_INT: {
                return "add(long)";
            }
            case SMALL_INT: {
                return "add(short)";
            }
            case INT: 
            case OID: {
                return "add(int)";
            }
            case NUMERIC: {
                return "add(BigDecimal)";
            }
            case DOUBLE: {
                return "add(double)";
            }
            case BYTES: {
                return "add(byte[])";
            }
            case TEXT: 
            case VARCHAR: 
            case CHAR: 
            case JSON: {
                return "add(String)";
            }
            case DATE: {
                return "add(LocalDate)";
            }
            case INTERVAL: {
                return "add(Interval)";
            }
            case TIME: {
                return "add(LocalTime)";
            }
            case TIMESTAMP: {
                return "add(LocalDateTime)";
            }
            case TIMESTAMP_TZ: {
                return "add(OffsetDateTime)";
            }
            case GEOGRAPHY: {
                return "addGeography";
            }
        }
        return "";
    }

    private void destroyChunk() {
        if (this.chunkHandle != null) {
            this.chunkBuffer = null;
            HyperAPI.hyper_destroy_data_chunk(this.chunkHandle);
            this.chunkHandle = null;
        }
    }

    private void destroySchema() {
        if (this.tableDefHandle != null) {
            HyperAPI.hyper_destroy_table_definition(this.tableDefHandle);
            this.tableDefHandle = null;
        }
    }

    private void close(boolean insertData, boolean throwOnError) {
        if (this.isOpen()) {
            this.destroyChunk();
            this.destroySchema();
            Pointer error = HyperAPI.hyper_close_inserter(this.inserterHandle, insertData);
            this.inserterHandle = null;
            if (throwOnError) {
                NativeHandleHelpers.throwHyperExceptionOnError(error);
            } else if (error != null) {
                HyperAPI.hyper_error_destroy(error);
            }
        }
    }

    public void execute() {
        this.throwIfClosed();
        if (this.currentColumn > 0) {
            this.close();
            throw new IllegalStateException("At execute(), the current row was not previously inserted: Always call endRow() on remaining rows before executing the inserter.");
        }
        if (this.streamDefinition.getColumnCount() == 0 && !this.selectList.isEmpty()) {
            Pointer error = HyperAPI.hyper_insert_computed_expressions(this.inserterHandle, this.selectList);
            this.throwNativeErrorAndClose(error);
        } else {
            this.sendChunk(false);
        }
        this.close(true, true);
    }

    @Override
    public void close() {
        this.close(false, false);
    }

    public boolean isOpen() {
        return this.inserterHandle != null;
    }

    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    private void checkCurrentColumnBeforeAdd(String methodName) {
        this.throwIfClosed();
        this.throwIfRowComplete(methodName);
    }

    public Inserter addNull() {
        this.checkCurrentColumnBeforeAdd("addNull");
        if (this.streamDefinition.getColumn(this.currentColumn).getNullability() == Nullability.NOT_NULLABLE) {
            this.close();
            throw new IllegalStateException("Failed to insert into table " + this.streamDefinition.getTableName() + ": `Inserter.addNull()` was called for a non-nullable column: Column \"" + this.streamDefinition.getColumn(this.currentColumn).getName().getUnescaped() + "\" is defined as NOT NULL");
        }
        this.ensureChunkSize(1);
        this.chunkBuffer.put((byte)1);
        ++this.currentColumn;
        return this;
    }

    public Inserter add(boolean value) {
        this.checkCurrentColumnBeforeAdd("add(boolean)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case BOOL: {
                this.ensureChunkSize(1);
                this.addNullByteIfNecessary();
                this.chunkBuffer.put((byte)(value ? 1 : 0));
                ++this.currentColumn;
                return this;
            }
        }
        this.throwTypeMismatch("add(boolean)");
        return this;
    }

    public Inserter add(long value) {
        this.checkCurrentColumnBeforeAdd("add(long)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case BIG_INT: {
                return this.addBigIntInternal(value);
            }
            case NUMERIC: {
                return this.addNumericInternal(new BigDecimal(value));
            }
            case DOUBLE: {
                return this.addDoubleInternal(value);
            }
        }
        this.throwTypeMismatch("add(long)");
        return this;
    }

    public Inserter add(short value) {
        this.checkCurrentColumnBeforeAdd("add(short)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case SMALL_INT: {
                return this.addSmallIntInternal(value);
            }
            case INT: 
            case OID: {
                return this.addIntInternal(value);
            }
            case BIG_INT: {
                return this.addBigIntInternal(value);
            }
            case NUMERIC: {
                return this.addNumericInternal(new BigDecimal(value));
            }
            case DOUBLE: {
                return this.addDoubleInternal(value);
            }
        }
        this.throwTypeMismatch("add(long)");
        return this;
    }

    public Inserter add(int value) {
        this.checkCurrentColumnBeforeAdd("add(int)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case INT: 
            case OID: {
                return this.addIntInternal(value);
            }
            case BIG_INT: {
                return this.addBigIntInternal(value);
            }
            case NUMERIC: {
                return this.addNumericInternal(new BigDecimal(value));
            }
            case DOUBLE: {
                return this.addDoubleInternal(value);
            }
        }
        this.throwTypeMismatch("add(int)");
        return this;
    }

    public Inserter add(double value) {
        this.checkCurrentColumnBeforeAdd("add(double)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case DOUBLE: {
                return this.addDoubleInternal(value);
            }
        }
        this.throwTypeMismatch("add(double)");
        return this;
    }

    public Inserter add(BigDecimal value) {
        this.checkCurrentColumnBeforeAdd("add(BigDecimal)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case NUMERIC: {
                return this.addNumericInternal(value);
            }
            case DOUBLE: {
                return this.addDoubleInternal(value.doubleValue());
            }
        }
        this.throwTypeMismatch("add(BigDecimal)");
        return this;
    }

    public Inserter add(byte[] value) {
        this.checkCurrentColumnBeforeAdd("add(byte[])");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case BYTES: 
            case GEOGRAPHY: {
                return this.addBytesInternal(value, 0, value.length);
            }
            case TEXT: 
            case VARCHAR: 
            case CHAR: 
            case JSON: {
                return this.addUTF8Internal(value);
            }
        }
        this.throwTypeMismatch("add(byte[])");
        return this;
    }

    public Inserter add(String value) {
        this.checkCurrentColumnBeforeAdd("add(String)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case TEXT: 
            case VARCHAR: 
            case CHAR: 
            case JSON: {
                return this.addUTF8Internal(value.getBytes(StandardCharsets.UTF_8));
            }
        }
        this.throwTypeMismatch("add(String)");
        return this;
    }

    public Inserter add(Instant value) {
        this.checkCurrentColumnBeforeAdd("add(Instant)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case TIMESTAMP: 
            case TIMESTAMP_TZ: {
                LocalDateTime timestamp = LocalDateTime.ofInstant(value, utcTimeZone);
                return this.addTimestampInternal(HyperBinary.getRawTimestamp(timestamp));
            }
        }
        this.throwTypeMismatch("add(Instant)");
        return this;
    }

    public Inserter add(LocalDate value) {
        this.checkCurrentColumnBeforeAdd("add(LocalDate)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case DATE: {
                return this.addDateInternal(HyperBinary.getRawDate(value));
            }
        }
        this.throwTypeMismatch("add(LocalDate)");
        return this;
    }

    public Inserter add(Date value) {
        this.checkCurrentColumnBeforeAdd("add(Date)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case TIMESTAMP: 
            case TIMESTAMP_TZ: {
                LocalDateTime timestamp = LocalDateTime.ofInstant(value.toInstant(), utcTimeZone);
                return this.addTimestampInternal(HyperBinary.getRawTimestamp(timestamp));
            }
        }
        this.throwTypeMismatch("add(Date)");
        return this;
    }

    public Inserter add(LocalDateTime value) {
        this.checkCurrentColumnBeforeAdd("add(LocalDateTime)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case TIMESTAMP: {
                return this.addTimestampInternal(HyperBinary.getRawTimestamp(value));
            }
        }
        this.throwTypeMismatch("add(LocalDateTime)");
        return this;
    }

    public Inserter add(OffsetDateTime value) {
        this.checkCurrentColumnBeforeAdd("add(OffsetDateTime)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case TIMESTAMP_TZ: {
                LocalDateTime convertedValue = value.withOffsetSameInstant(ZoneOffset.UTC).toLocalDateTime();
                return this.addTimestampInternal(HyperBinary.getRawTimestamp(convertedValue));
            }
        }
        this.throwTypeMismatch("add(OffsetDateTime)");
        return this;
    }

    public Inserter add(ZonedDateTime value) {
        this.checkCurrentColumnBeforeAdd("add(ZonedDateTime)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case TIMESTAMP_TZ: {
                LocalDateTime convertedValue = value.withZoneSameInstant(utcTimeZone).toLocalDateTime();
                return this.addTimestampInternal(HyperBinary.getRawTimestamp(convertedValue));
            }
        }
        this.throwTypeMismatch("add(ZonedDateTime)");
        return this;
    }

    public Inserter add(LocalTime value) {
        this.checkCurrentColumnBeforeAdd("add(LocalTime)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case TIME: {
                return this.addTimeInternal(HyperBinary.getRawTime(value));
            }
        }
        this.throwTypeMismatch("add(LocalTime)");
        return this;
    }

    public Inserter add(Interval value) {
        this.checkCurrentColumnBeforeAdd("add(Interval)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case INTERVAL: {
                return this.addIntervalInternal(value.getRaw());
            }
        }
        this.throwTypeMismatch("add(Interval)");
        return this;
    }

    public Inserter add(byte[] value, int offset, int length) {
        this.checkCurrentColumnBeforeAdd("add(byte[], offset, length)");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case BYTES: 
            case GEOGRAPHY: {
                return this.addBytesInternal(value, offset, length);
            }
        }
        this.throwTypeMismatch("add(byte[], offset, length)");
        return this;
    }

    private Inserter addSmallIntInternal(short value) {
        this.ensureChunkSize(2);
        this.addNullByteIfNecessary();
        this.chunkBuffer.putShort(value);
        ++this.currentColumn;
        return this;
    }

    private Inserter addIntInternal(int value) {
        this.ensureChunkSize(4);
        this.addNullByteIfNecessary();
        this.chunkBuffer.putInt(value);
        ++this.currentColumn;
        return this;
    }

    private Inserter addBigIntInternal(long value) {
        this.ensureChunkSize(8);
        this.addNullByteIfNecessary();
        this.chunkBuffer.putLong(value);
        ++this.currentColumn;
        return this;
    }

    private Inserter addDoubleInternal(double value) {
        this.ensureChunkSize(8);
        this.addNullByteIfNecessary();
        this.chunkBuffer.putDouble(value);
        ++this.currentColumn;
        return this;
    }

    private Inserter addNumericInternal(BigDecimal value) {
        SqlType type = this.streamDefinition.getColumn(this.currentColumn).getType();
        int precision = type.getPrecision().orElseThrow(() -> new InternalError("Numeric column without precision."));
        int scale = type.getScale().orElseThrow(() -> new InternalError("Numeric column without scale."));
        BigDecimal correctScale = value.setScale(scale, 4);
        if (precision <= 18) {
            this.ensureChunkSize(8);
            this.addNullByteIfNecessary();
            this.chunkBuffer.putLong(correctScale.unscaledValue().longValue());
        } else {
            this.ensureChunkSize(16);
            this.addNullByteIfNecessary();
            byte[] bytes = correctScale.unscaledValue().toByteArray();
            if (bytes.length > 16) {
                throw new IllegalArgumentException("Numerical value too large.");
            }
            for (int i = bytes.length - 1; i >= 0; --i) {
                this.chunkBuffer.put(bytes[i]);
            }
            byte signByte = correctScale.signum() < 0 ? (byte)-1 : 0;
            for (int i = bytes.length; i < 16; ++i) {
                this.chunkBuffer.put(signByte);
            }
        }
        ++this.currentColumn;
        return this;
    }

    private Inserter addBytesInternal(byte[] value, int offset, int length) {
        this.ensureChunkSize(4 + length - offset);
        this.addNullByteIfNecessary();
        this.chunkBuffer.putInt(length - offset);
        this.chunkBuffer.put(value, offset, length);
        ++this.currentColumn;
        return this;
    }

    private Inserter addUTF8Internal(byte[] value) {
        this.ensureChunkSize(4 + value.length);
        this.addNullByteIfNecessary();
        this.chunkBuffer.putInt(value.length);
        this.chunkBuffer.put(value);
        ++this.currentColumn;
        return this;
    }

    public Inserter addDate(int year, int month, int day) {
        this.checkCurrentColumnBeforeAdd("addDate");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case DATE: {
                return this.addDateInternal(HyperBinary.getRawDate(year, month, day));
            }
        }
        this.throwTypeMismatch("addDate");
        return this;
    }

    private Inserter addDateInternal(int rawDate) {
        this.ensureChunkSize(4);
        this.addNullByteIfNecessary();
        this.chunkBuffer.putInt(rawDate);
        ++this.currentColumn;
        return this;
    }

    public Inserter addInterval(int years, int months, int days, int hours, int minutes, int seconds, int microseconds) {
        this.checkCurrentColumnBeforeAdd("addInterval");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case INTERVAL: {
                return this.addIntervalInternal(Interval.getRawInterval(years, months, days, hours, minutes, seconds, microseconds));
            }
        }
        this.throwTypeMismatch("addInterval");
        return this;
    }

    private Inserter addIntervalInternal(Interval.RawInterval rawInterval) {
        this.ensureChunkSize(16);
        this.addNullByteIfNecessary();
        this.chunkBuffer.putLong(rawInterval.data1);
        this.chunkBuffer.putLong(rawInterval.data2);
        ++this.currentColumn;
        return this;
    }

    public Inserter addTime(int hour, int minute, int second, int microsecond) {
        this.checkCurrentColumnBeforeAdd("addTime");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case TIME: {
                return this.addTimeInternal(HyperBinary.getRawTime(hour, minute, second, microsecond));
            }
        }
        this.throwTypeMismatch("addTime");
        return this;
    }

    public Inserter addTime(int hour, int minute, int second) {
        return this.addTime(hour, minute, second, 0);
    }

    private Inserter addTimeInternal(long rawTime) {
        this.ensureChunkSize(8);
        this.addNullByteIfNecessary();
        this.chunkBuffer.putLong(rawTime);
        ++this.currentColumn;
        return this;
    }

    public Inserter addTimestamp(int year, int month, int day, int hour, int minute, int second, int microsecond) {
        this.checkCurrentColumnBeforeAdd("addTimestamp");
        switch (this.streamDefinition.getColumn(this.currentColumn).getType().getTag()) {
            case TIMESTAMP: 
            case TIMESTAMP_TZ: {
                return this.addTimestampInternal(HyperBinary.getRawTimestamp(year, month, day, hour, minute, second, microsecond));
            }
        }
        this.throwTypeMismatch("addTimestamp");
        return this;
    }

    private Inserter addTimestampInternal(long rawTimestamp) {
        this.ensureChunkSize(8);
        this.addNullByteIfNecessary();
        this.chunkBuffer.putLong(rawTimestamp);
        ++this.currentColumn;
        return this;
    }

    public Inserter endRow() {
        this.throwIfClosed();
        if (this.currentColumn != this.streamDefinition.getColumnCount()) {
            this.close();
            throw new IllegalStateException("Failed to insert into table " + this.streamDefinition.getTableName() + ": `Inserter.endRow()` was called for an incomplete row with " + this.currentColumn + " values: Table " + this.streamDefinition.getTableName() + " has " + this.streamDefinition.getColumnCount() + " columns.");
        }
        this.currentColumn = 0;
        ++this.chunkRows;
        this.currentRowOffset = this.chunkBuffer.position();
        return this;
    }

    protected void finalize() {
        if (this.inserterHandle != null) {
            System.err.println("ERROR: Inserter.finalize called with an existing inserter handle. Call close() or use try-with-resources.");
        }
    }

    private void sendChunk(boolean bulkInsert) {
        this.throwIfClosed();
        if (bulkInsert) {
            Pointer error = HyperAPI.hyper_init_bulk_insert(this.inserterHandle, this.streamDefHandle, this.selectList);
            this.throwNativeErrorAndClose(error);
        }
        long chunkBytes = this.chunkHeaderSize + (long)this.currentRowOffset;
        Pointer error = HyperAPI.hyper_inserter_insert_chunk(this.inserterHandle, this.chunkData, chunkBytes);
        this.throwNativeErrorAndClose(error);
        this.chunkBuffer.limit(this.chunkBuffer.position());
        this.chunkBuffer.position(this.currentRowOffset);
        this.chunkBuffer.compact();
        this.currentRowOffset = 0;
        this.chunkRows = 0;
    }

    private void addNullByteIfNecessary() {
        if (this.streamDefinition.getColumn(this.currentColumn).getNullability() == Nullability.NULLABLE) {
            this.chunkBuffer.put((byte)0);
        }
    }

    private void ensureChunkSize(int bytes) {
        if (this.chunkBuffer.remaining() >= ++bytes) {
            return;
        }
        if (this.chunkRows == 0) {
            Pointer error = HyperAPI.hyper_resize_data_chunk(this.chunkHandle, this.chunkHeaderSize + (long)this.chunkBuffer.capacity() + (long)bytes);
            this.throwNativeErrorAndClose(error);
            long chunkDataSize = HyperAPI.hyper_get_chunk_data_size(this.chunkHandle);
            int position = this.chunkBuffer.position();
            this.chunkData = HyperAPI.hyper_get_chunk_data(this.chunkHandle);
            this.chunkBuffer = this.chunkData.getByteBuffer(this.chunkHeaderSize, chunkDataSize - this.chunkHeaderSize);
            this.chunkBuffer.position(position);
            return;
        }
        this.sendChunk(true);
    }

    private void throwIfClosed() {
        if (!this.isOpen()) {
            throw new InternalError("The inserter is closed.");
        }
    }

    private void throwIfRowComplete(String methodName) {
        if (this.currentColumn == this.streamDefinition.getColumnCount()) {
            this.close();
            throw new IllegalStateException("Failed to insert into table " + this.streamDefinition.getTableName() + ": `Inserter." + methodName + "` was called for a complete row: Table " + this.streamDefinition.getTableName() + " has " + this.streamDefinition.getColumnCount() + " columns.");
        }
    }

    private void throwTypeMismatch(String methodName) {
        TableDefinition.Column column = this.streamDefinition.getColumn(this.currentColumn);
        TypeTag actualType = column.getType().getTag();
        this.close();
        throw new IllegalStateException(methodName + " cannot be used for column \"" + column.getName().getUnescaped() + "\", which is of type " + (Object)((Object)actualType) + ": Use " + Inserter.getMatchingAddMethodName(actualType) + ".");
    }

    private void throwNativeErrorAndClose(Pointer nativeError) {
        if (nativeError != null) {
            this.close();
            HyperException cause = new HyperException(nativeError);
            HyperException error = new HyperException("Failed to insert into table " + this.streamDefinition.getTableName() + ":" + cause.getMessage(), "Check that the table exists and the added values match the table definition.", cause, new HyperException.ContextId(-2007893453));
            throw error;
        }
    }

    public static final class ColumnMapping {
        private Name columnName;
        private String expression;

        public ColumnMapping(Name columnName, String expression) {
            this.columnName = columnName;
            this.expression = expression;
        }

        public ColumnMapping(Name columnName) {
            this(columnName, null);
        }

        public ColumnMapping(String columnName, String expression) {
            this(new Name(columnName), expression);
        }

        public ColumnMapping(String columnName) {
            this(new Name(columnName), null);
        }

        public Name getColumnName() {
            return this.columnName;
        }

        public Optional<String> getExpression() {
            return Optional.ofNullable(this.expression);
        }

        private String asSelectListExpression() {
            if (this.expression != null) {
                return this.expression + " AS " + this.columnName.toString();
            }
            return this.columnName.toString();
        }
    }
}

