/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.tableau.hyperapi.DatabaseName;
import com.tableau.hyperapi.Name;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;

public final class SchemaName
implements Comparable<SchemaName> {
    private static Comparator<SchemaName> schemaNameComparator = SchemaName.initSchemaNameComparator();
    public static Comparator<SchemaName> nullSafeSchemaNameComparator = Comparator.nullsFirst(SchemaName::compareTo);
    private Name schemaName;
    private DatabaseName databaseName;

    private static Comparator<SchemaName> initSchemaNameComparator() {
        return Comparator.comparing(name -> name.databaseName, DatabaseName.nullSafeDatabaseNameComparator).thenComparing(name -> name.schemaName);
    }

    public SchemaName(Name schemaName) {
        this.schemaName = schemaName;
    }

    public SchemaName(String schemaName) {
        this(new Name(schemaName));
    }

    public SchemaName(DatabaseName databaseName, Name schemaName) {
        assert (schemaName != null);
        this.schemaName = schemaName;
        this.databaseName = databaseName;
    }

    public SchemaName(Name databaseName, Name schemaName) {
        this(databaseName == null ? null : new DatabaseName(databaseName), schemaName);
    }

    public SchemaName(String databaseName, Name schemaName) {
        this(new DatabaseName(databaseName), schemaName);
    }

    public SchemaName(DatabaseName databaseName, String schemaName) {
        this(databaseName, new Name(schemaName));
    }

    public SchemaName(Name databaseName, String schemaName) {
        this(new DatabaseName(databaseName), new Name(schemaName));
    }

    public SchemaName(String databaseName, String schemaName) {
        this(new DatabaseName(databaseName), new Name(schemaName));
    }

    public String toString() {
        if (this.databaseName != null) {
            return this.databaseName.toString() + "." + this.schemaName.toString();
        }
        return this.schemaName.toString();
    }

    public Name getName() {
        return this.schemaName;
    }

    public Optional<DatabaseName> getDatabaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    String getDatabaseNameOrNull() {
        if (this.databaseName != null) {
            return this.databaseName.getName().getUnescaped();
        }
        return null;
    }

    public boolean isFullyQualified() {
        return this.databaseName != null;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof SchemaName) {
            SchemaName other = (SchemaName)that;
            return Objects.equals(this.databaseName, other.databaseName) && this.schemaName.equals(other.schemaName);
        }
        return false;
    }

    @Override
    public int compareTo(SchemaName other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        return schemaNameComparator.compare(this, other);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.schemaName);
    }
}

