/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import com.tableau.hyperapi.HyperAPI;
import com.tableau.hyperapi.HyperException;

public final class OpenSSL {
    private OpenSSL() {
    }

    public static void initialize(String modulesDir, String configPath, boolean forceFips) {
        Pointer error = HyperAPI.hyper_openssl_initialize(modulesDir, configPath, forceFips);
        if (error != null) {
            throw new HyperException(error);
        }
    }

    public static void unload() {
        HyperAPI.hyper_openssl_unload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLoadedModules() {
        PointerByReference modules = new PointerByReference();
        HyperAPI.hyper_openssl_get_loaded_modules(modules);
        if (modules.getValue() == null) {
            throw new HyperException(HyperAPI.hyper_error_create(0));
        }
        try {
            long size = HyperAPI.hyper_string_list_size(modules.getValue());
            String[] result = new String[(int)size];
            int i = 0;
            while ((long)i < size) {
                result[i] = HyperAPI.hyper_string_list_at(modules.getValue(), i);
                ++i;
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            HyperAPI.hyper_string_list_destroy(modules.getValue());
        }
    }
}

