/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import com.tableau.hyperapi.Endpoint;
import com.tableau.hyperapi.HyperAPI;
import com.tableau.hyperapi.NativeHandleHelpers;
import com.tableau.hyperapi.Telemetry;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public final class HyperProcess
implements AutoCloseable {
    private Pointer handle;
    private Endpoint endpoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HyperProcess(Path hyperPath, Telemetry telemetry, String userAgent, Map<String, String> parameters) {
        PointerByReference parametersByRef = new PointerByReference();
        Pointer parametersHandle = null;
        try {
            Pointer error = HyperAPI.hyper_create_instance_parameters(parametersByRef, true);
            NativeHandleHelpers.throwHyperExceptionOnError(error);
            parametersHandle = parametersByRef.getValue();
            if (parametersHandle == null) {
                throw new OutOfMemoryError();
            }
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                this.setInstanceParameter(parametersHandle, parameter.getKey(), parameter.getValue());
            }
            String hyperPathArg = null;
            hyperPathArg = hyperPath == null || hyperPath.toString().isEmpty() ? HyperProcess.findHyperPath().toString() : hyperPath.toString();
            PointerByReference handleByRef = new PointerByReference();
            error = HyperAPI.hyper_instance_create(hyperPathArg, telemetry.getValue(), parametersByRef.getValue(), handleByRef);
            NativeHandleHelpers.throwHyperExceptionOnError(error);
            this.handle = handleByRef.getValue();
            this.endpoint = new Endpoint(HyperAPI.hyper_instance_get_endpoint_descriptor(this.handle), userAgent);
            if (parametersHandle == null) return;
        }
        catch (Throwable throwable) {
            if (parametersHandle == null) throw throwable;
            HyperAPI.hyper_parameters_destroy(parametersHandle);
            throw throwable;
        }
        HyperAPI.hyper_parameters_destroy(parametersHandle);
    }

    public HyperProcess(Path hyperPath, Telemetry telemetry, String userAgent) {
        this(hyperPath, telemetry, userAgent, new HashMap<String, String>());
    }

    public HyperProcess(Telemetry telemetry, String userAgent, Map<String, String> parameters) {
        this(null, telemetry, userAgent, parameters);
    }

    public HyperProcess(Telemetry telemetry, String userAgent) {
        this(telemetry, userAgent, new HashMap<String, String>());
    }

    public HyperProcess(Path hyperPath, Telemetry telemetry) {
        this(hyperPath, telemetry, "", new HashMap<String, String>());
    }

    public HyperProcess(Telemetry telemetry) {
        this(null, telemetry, "", new HashMap<String, String>());
    }

    private static Path findHyperPath() {
        Path jarPath;
        try {
            jarPath = new File(HyperProcess.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toPath();
        }
        catch (URISyntaxException e) {
            throw new InternalError("Could not resolve jar directory");
        }
        Path libraryFolder = jarPath.getParent();
        Path hyperFolder = libraryFolder.resolve("hyper");
        return hyperFolder;
    }

    private void setInstanceParameter(Pointer parameters, String key, String value) {
        Pointer error = HyperAPI.hyper_parameters_set(parameters, key, value);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
    }

    public void shutdown(int timeoutMs) {
        if (this.isOpen()) {
            Pointer error = HyperAPI.hyper_instance_shutdown(this.handle, timeoutMs);
            this.handle = null;
            NativeHandleHelpers.throwHyperExceptionOnError(error);
        }
    }

    public void shutdown() {
        this.shutdown(-1);
    }

    public Endpoint getEndpoint() {
        this.throwIfClosed();
        return this.endpoint;
    }

    public boolean isOpen() {
        return this.handle != null;
    }

    private void throwIfClosed() {
        if (!this.isOpen()) {
            throw new InternalError("The Hyper process is closed.");
        }
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            HyperAPI.hyper_instance_close(this.handle);
            this.handle = null;
        }
    }

    protected void finalize() {
        if (this.isOpen()) {
            System.err.println("ERROR: HyperProcess.finalize called with an existing HyperProcess handle. Call close() or use try-with-resources.");
        }
    }

    Pointer handle() {
        return this.handle;
    }
}

