/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.tableau.hyperapi.Catalog;
import com.tableau.hyperapi.CreateMode;
import com.tableau.hyperapi.Endpoint;
import com.tableau.hyperapi.HyperAPI;
import com.tableau.hyperapi.HyperException;
import com.tableau.hyperapi.NativeHandleHelpers;
import com.tableau.hyperapi.Result;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.Semaphore;

public final class Connection
implements AutoCloseable {
    private Pointer handle;
    private Semaphore semaphore;
    private Catalog catalog;

    public Connection(Endpoint endpoint, String database, CreateMode createMode, Map<String, String> parameters) {
        this(endpoint, new String[]{database}, createMode, parameters);
    }

    public Connection(Endpoint endpoint, String database, CreateMode createMode) {
        this(endpoint, new String[]{database}, createMode, new HashMap<String, String>());
    }

    public Connection(Endpoint endpoint, String database) {
        this(endpoint, new String[]{database}, CreateMode.NONE, new HashMap<String, String>());
    }

    public Connection(Endpoint endpoint, String[] databases) {
        this(endpoint, databases, CreateMode.NONE, new HashMap<String, String>());
    }

    public Connection(Endpoint endpoint) {
        this(endpoint, new String[0], CreateMode.NONE, new HashMap<String, String>());
    }

    public Connection(Endpoint endpoint, Map<String, String> parameters) {
        this(endpoint, new String[0], CreateMode.NONE, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection(Endpoint endpoint, String[] databases, CreateMode createMode, Map<String, String> parameters) {
        block10: {
            this.semaphore = new Semaphore(1);
            if (databases.length > 1) {
                throw new UnsupportedOperationException("Connecting to multiple databases not implemented yet");
            }
            PointerByReference parametersByRef = new PointerByReference();
            Pointer parametersHandle = null;
            try {
                Pointer error = HyperAPI.hyper_create_connection_parameters(null, parametersByRef);
                NativeHandleHelpers.throwHyperExceptionOnError(error);
                parametersHandle = parametersByRef.getValue();
                if (parametersHandle == null) {
                    throw new OutOfMemoryError();
                }
                for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                    Connection.setConnectionParameter(parametersHandle, parameter.getKey(), parameter.getValue());
                }
                Connection.setConnectionParameter(parametersHandle, "endpoint", endpoint.getConnectionDescriptor());
                if (!endpoint.getUserAgent().isEmpty()) {
                    Connection.setConnectionParameter(parametersHandle, "user_agent", endpoint.getUserAgent());
                }
                Connection.setConnectionParameter(parametersHandle, "api_language", "Java");
                if (databases.length > 0 && !databases[0].isEmpty()) {
                    Connection.setConnectionParameter(parametersHandle, "dbname", databases[0]);
                }
                PointerByReference connectionByRef = new PointerByReference();
                error = HyperAPI.hyper_connect(parametersHandle, connectionByRef, createMode.getValue());
                this.handle = connectionByRef.getValue();
                if (error != null) {
                    assert (this.handle == null);
                    throw new HyperException(error);
                }
                if (parametersHandle == null) break block10;
            }
            catch (Throwable throwable) {
                if (parametersHandle != null) {
                    HyperAPI.hyper_parameters_destroy(parametersHandle);
                }
                throw throwable;
            }
            HyperAPI.hyper_parameters_destroy(parametersHandle);
        }
        this.catalog = new Catalog(this);
    }

    static void setConnectionParameter(Pointer parameters, String key, String value) {
        Pointer error = HyperAPI.hyper_parameters_set(parameters, key, value);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
    }

    public Result executeQuery(String sql) {
        this.throwIfClosed();
        PointerByReference rowsetByRef = new PointerByReference();
        Pointer error = HyperAPI.hyper_execute_query(this.handle, sql, rowsetByRef);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
        return new Result(this, rowsetByRef.getValue());
    }

    public OptionalLong executeCommand(String sql) {
        this.throwIfClosed();
        IntByReference affectedRowCount = new IntByReference();
        affectedRowCount.setValue(-1);
        Pointer error = HyperAPI.hyper_execute_command(this.handle, sql, affectedRowCount);
        NativeHandleHelpers.throwHyperExceptionOnError(error);
        if (affectedRowCount.getValue() == -1) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(affectedRowCount.getValue());
    }

    public <T> Optional<T> executeScalarQuery(String sql) {
        Optional<Object> value = Optional.empty();
        String detailMessage = "";
        try (Result result = this.executeQuery(sql);){
            int columnCount = result.getSchema().getColumnCount();
            if (result.nextRow()) {
                if (columnCount == 1) {
                    if (!result.isNull(0)) {
                        Object v = result.getObject(0);
                        value = Optional.of(v);
                    }
                } else {
                    detailMessage = "The query result has " + columnCount + " columns.";
                }
            } else {
                detailMessage = "The query result is empty.";
            }
            if (result.nextRow()) {
                detailMessage = "The query result has more than one row.";
            }
        }
        if (!detailMessage.isEmpty()) {
            throw new HyperException("The query did not return a scalar value: " + detailMessage, "Use executeScalarQuery() only for queries that return exactly one row with one column.", null, new HyperException.ContextId(-722622711));
        }
        return value;
    }

    public Catalog getCatalog() {
        this.throwIfClosed();
        return this.catalog;
    }

    public void cancel() {
        Pointer error;
        this.semaphore.acquireUninterruptibly();
        if (this.handle != null && (error = HyperAPI.hyper_cancel(this.handle)) != null) {
            HyperAPI.hyper_error_destroy(error);
        }
        this.semaphore.release();
    }

    public boolean isReady() {
        return HyperAPI.hyper_connection_is_ready(this.handle);
    }

    public boolean isOpen() {
        return this.handle != null;
    }

    void throwIfClosed() {
        if (!this.isOpen()) {
            throw new InternalError("The connection is closed.");
        }
    }

    @Override
    public void close() {
        this.semaphore.acquireUninterruptibly();
        if (this.handle != null) {
            HyperAPI.hyper_disconnect(this.handle);
            this.handle = null;
        }
        this.semaphore.release();
    }

    protected void finalize() {
        if (this.handle != null) {
            System.err.println("ERROR: Connection.finalize called with an existing connection handle. Call close() or use try-with-resources.");
        }
    }

    Pointer handle() {
        this.throwIfClosed();
        return this.handle;
    }
}

