/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.tableau.hyperapi.HyperAPI;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Objects;

public final class Name
implements Comparable<Name> {
    private final Charset UTF8CharSet = Charset.forName("UTF-8");
    private String name;
    private String unescapedName;

    public Name(String unescapedName) {
        assert (unescapedName != null);
        if (unescapedName.isEmpty()) {
            throw new IllegalArgumentException("A name must not be empty.");
        }
        this.unescapedName = unescapedName;
        int length = unescapedName.getBytes(this.UTF8CharSet).length;
        int requiredSize = HyperAPI.hyper_quote_sql_identifier(null, 0, unescapedName, length);
        byte[] nameOut = new byte[requiredSize];
        int actualSize = HyperAPI.hyper_quote_sql_identifier(nameOut, requiredSize, unescapedName, length);
        assert (requiredSize == actualSize);
        this.name = new String(nameOut, this.UTF8CharSet);
    }

    public String toString() {
        return this.name;
    }

    public String getUnescaped() {
        return this.unescapedName;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof Name) {
            Name other = (Name)that;
            return this.unescapedName.equals(other.unescapedName);
        }
        return false;
    }

    @Override
    public int compareTo(Name other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        return Comparator.comparing(name -> name.unescapedName).compare(this, other);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

