/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import com.tableau.hyperapi.HyperAPIUtil;
import com.tableau.hyperapi.impl.BoolByReference;
import com.tableau.hyperapi.impl.SharedLibraryProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;

class HyperAPI {
    HyperAPI() {
    }

    private static Map<String, Object> getJNAOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("classloader", HyperAPI.class.getClassLoader());
        options.put("string-encoding", "UTF-8");
        return options;
    }

    private static File getTempDir() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        return tempDir;
    }

    private static String extractHapiLibrary() {
        try {
            InputStream libAsStream = HyperAPI.getHapiLibAsInputStream();
            if (libAsStream == null) {
                throw new IllegalStateException("HyperAPI native lib not found");
            }
            String checksum = HyperAPIUtil.checksum(libAsStream);
            File destinationHyperLibDir = new File(HyperAPI.getTempDir(), "extracted-hapi-" + checksum);
            File destinationHyperLib = new File(destinationHyperLibDir, HyperAPI.getNativeLibFileName());
            if (!destinationHyperLibDir.exists()) {
                destinationHyperLibDir.mkdirs();
            }
            if (!destinationHyperLib.exists()) {
                String id = UUID.randomUUID().toString();
                File extractedHyperLib = new File(destinationHyperLibDir, "extracted-" + id + "-" + HyperAPI.getNativeLibFileName());
                if (extractedHyperLib.exists()) {
                    Files.delete(extractedHyperLib.toPath());
                }
                Files.copy(HyperAPI.getHapiLibAsInputStream(), extractedHyperLib.toPath(), new CopyOption[0]);
                extractedHyperLib.deleteOnExit();
                try {
                    Files.createLink(destinationHyperLib.toPath(), extractedHyperLib.toPath());
                    HyperAPI.deleteFileIgnoreErrors(extractedHyperLib);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                }
                catch (IOException | UnsupportedOperationException e) {
                    destinationHyperLib = extractedHyperLib;
                }
            }
            return destinationHyperLib.getAbsolutePath();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to set searchPath for hyperapi", e);
        }
    }

    private static void deleteFileIgnoreErrors(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static InputStream getHapiLibAsInputStream() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(Platform.RESOURCE_PREFIX + "/" + HyperAPI.getNativeLibFileName());
    }

    private static void registerJNA() {
        if (Boolean.getBoolean("jna.nounpack")) {
            Native.register((String)HyperAPI.getLibraryBaseName());
        } else if (System.getProperty("hyperapi.library.path") != null) {
            Native.register(HyperAPI.class, (NativeLibrary)NativeLibrary.getInstance((String)System.getProperty("hyperapi.library.path"), HyperAPI.getJNAOptions()));
        } else {
            Native.register(HyperAPI.class, (NativeLibrary)NativeLibrary.getInstance((String)HyperAPI.extractHapiLibrary(), HyperAPI.getJNAOptions()));
        }
    }

    protected static String getLibraryBaseName() {
        Iterator<SharedLibraryProvider> sharedLibraryProviders = ServiceLoader.load(SharedLibraryProvider.class).iterator();
        if (!sharedLibraryProviders.hasNext()) {
            throw new IllegalStateException("A shared library provider must be provided.");
        }
        String baseName = sharedLibraryProviders.next().getSharedLibraryBaseName();
        if (sharedLibraryProviders.hasNext()) {
            throw new IllegalStateException("Only a single shared library provider may be provided.");
        }
        return baseName;
    }

    static String getNativeLibFileName() {
        return System.mapLibraryName(HyperAPI.getLibraryBaseName());
    }

    protected static native Pointer hyper_error_create(int var0);

    protected static native void hyper_error_destroy(Pointer var0);

    protected static native Pointer hyper_error_get_field(Pointer var0, int var1, hyper_error_field_value.ByReference var2);

    protected static native Pointer hyper_error_set_field(Pointer var0, int var1, hyper_error_field_value.ByValue var2);

    protected static native Pointer hyper_instance_create(String var0, int var1, Pointer var2, PointerByReference var3);

    protected static native void hyper_instance_close(Pointer var0);

    protected static native Pointer hyper_instance_shutdown(Pointer var0, int var1);

    protected static native String hyper_instance_get_endpoint_descriptor(Pointer var0);

    protected static native Pointer hyper_create_instance_parameters(PointerByReference var0, boolean var1);

    protected static native Pointer hyper_create_connection_parameters(Pointer var0, PointerByReference var1);

    protected static native void hyper_parameters_destroy(Pointer var0);

    protected static native Pointer hyper_parameters_set(Pointer var0, String var1, String var2);

    protected static native int hyper_connection_status(Pointer var0);

    protected static native boolean hyper_connection_is_ready(Pointer var0);

    protected static native Pointer hyper_cancel(Pointer var0);

    protected static native Pointer hyper_connect(Pointer var0, PointerByReference var1, int var2);

    protected static native void hyper_disconnect(Pointer var0);

    protected static native int hyper_encode_numeric_modifier(int var0, int var1);

    protected static native int hyper_encode_string_modifier(int var0);

    protected static native int hyper_get_max_length_from_modifier(int var0);

    protected static native int hyper_get_precision_from_modifier(int var0);

    protected static native int hyper_get_scale_from_modifier(int var0);

    protected static native Pointer hyper_create_database(Pointer var0, String var1, boolean var2);

    protected static native Pointer hyper_drop_database(Pointer var0, String var1, boolean var2);

    protected static native Pointer hyper_attach_database(Pointer var0, String var1, String var2);

    protected static native Pointer hyper_detach_database(Pointer var0, String var1);

    protected static native Pointer hyper_detach_all_databases(Pointer var0);

    protected static native Pointer hyper_create_table_definition(String var0, String var1, String var2, int var3, boolean var4);

    protected static native void hyper_destroy_table_definition(Pointer var0);

    protected static native Pointer hyper_get_table_definition(Pointer var0, String var1, String var2, String var3, PointerByReference var4);

    protected static native String hyper_table_definition_database_name(Pointer var0);

    protected static native String hyper_table_definition_schema_name(Pointer var0);

    protected static native String hyper_table_definition_table_name(Pointer var0);

    protected static native int hyper_table_definition_table_persistence(Pointer var0);

    protected static native Pointer hyper_table_definition_add_column(Pointer var0, String var1, int var2, int var3, String var4, boolean var5);

    protected static native String hyper_table_definition_column_collation(Pointer var0, int var1);

    protected static native int hyper_table_definition_column_count(Pointer var0);

    protected static native String hyper_table_definition_column_name(Pointer var0, int var1);

    protected static native int hyper_table_definition_column_type_tag(Pointer var0, int var1);

    protected static native int hyper_table_definition_column_type_oid(Pointer var0, int var1);

    protected static native int hyper_table_definition_column_index(Pointer var0, String var1);

    protected static native int hyper_table_definition_column_type_modifier(Pointer var0, int var1);

    protected static native boolean hyper_table_definition_column_is_nullable(Pointer var0, int var1);

    protected static native void hyper_string_list_destroy(Pointer var0);

    protected static native int hyper_string_list_size(Pointer var0);

    protected static native String hyper_string_list_at(Pointer var0, int var1);

    protected static native Pointer hyper_get_schema_names(Pointer var0, String var1, PointerByReference var2);

    protected static native Pointer hyper_create_schema(Pointer var0, String var1, String var2, boolean var3);

    protected static native Pointer hyper_get_table_names(Pointer var0, String var1, String var2, PointerByReference var3);

    protected static native Pointer hyper_has_table(Pointer var0, String var1, String var2, String var3, BoolByReference var4);

    protected static native int hyper_quote_sql_identifier(byte[] var0, int var1, String var2, int var3);

    protected static native int hyper_quote_sql_literal(byte[] var0, int var1, String var2, int var3);

    protected static native Pointer hyper_create_table(Pointer var0, Pointer var1, boolean var2);

    protected static native Pointer hyper_create_inserter(Pointer var0, Pointer var1, PointerByReference var2);

    protected static native Pointer hyper_init_bulk_insert(Pointer var0, Pointer var1, String var2);

    protected static native Pointer hyper_insert_computed_expressions(Pointer var0, String var1);

    protected static native Pointer hyper_inserter_insert_chunk(Pointer var0, Pointer var1, long var2);

    protected static native Pointer hyper_close_inserter(Pointer var0, boolean var1);

    protected static native Pointer hyper_create_data_chunk();

    protected static native Pointer hyper_resize_data_chunk(Pointer var0, long var1);

    protected static native Pointer hyper_get_chunk_data(Pointer var0);

    protected static native long hyper_get_chunk_header_size(Pointer var0);

    protected static native long hyper_get_chunk_data_size(Pointer var0);

    protected static native void hyper_destroy_data_chunk(Pointer var0);

    protected static native Pointer hyper_execute_query(Pointer var0, String var1, PointerByReference var2);

    protected static native Pointer hyper_execute_command(Pointer var0, String var1, IntByReference var2);

    protected static native Pointer hyper_rowset_get_table_definition(Pointer var0);

    protected static native long hyper_rowset_get_affected_row_count(Pointer var0);

    protected static native void hyper_close_rowset(Pointer var0);

    protected static native Pointer hyper_rowset_get_next_chunk(Pointer var0, PointerByReference var1);

    protected static native void hyper_destroy_rowset_chunk(Pointer var0);

    protected static native long hyper_rowset_chunk_row_count(Pointer var0);

    protected static native void hyper_rowset_chunk_field_values(Pointer var0, LongByReference var1, LongByReference var2, PointerByReference var3, PointerByReference var4);

    protected static native Pointer hyper_openssl_initialize(String var0, String var1, boolean var2);

    protected static native void hyper_openssl_unload();

    protected static native void hyper_openssl_get_loaded_modules(PointerByReference var0);

    static {
        HyperAPI.registerJNA();
    }

    public static class hyper_error_field_value
    extends Structure {
        public int discriminator;
        public hyper_error_field_value_union value;

        protected List<String> getFieldOrder() {
            return Arrays.asList("discriminator", "value");
        }

        public static class ByReference
        extends hyper_error_field_value
        implements Structure.ByReference {
        }

        public static class ByValue
        extends hyper_error_field_value
        implements Structure.ByValue {
        }
    }

    public static class hyper_error_field_value_union
    extends Union {
        public int integer;
        public String string;
        public Pointer pointer;

        public static class ByReference
        extends hyper_error_field_value_union
        implements Structure.ByReference {
        }

        public static class ByValue
        extends hyper_error_field_value_union
        implements Structure.ByValue {
        }
    }

    protected static class hyper_service_version_t
    extends Structure {
        public int major;
        public int minor;
        static final int csize = 8;

        public hyper_service_version_t() {
        }

        public hyper_service_version_t(Pointer p) {
            super(p);
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("major", "minor");
        }

        public static class ByReference
        extends hyper_service_version_t
        implements Structure.ByReference {
        }

        public static class ByValue
        extends hyper_service_version_t
        implements Structure.ByValue {
        }
    }

    protected static class hyper_value_t
    extends Structure {
        public Pointer value = null;
        public long size = 0L;

        protected hyper_value_t() {
        }

        public static class ByReference
        extends hyper_value_t
        implements Structure.ByReference {
        }

        public static class ByValue
        extends hyper_value_t
        implements Structure.ByValue {
        }
    }

    protected static enum hyper_error_field_key {
        HYPER_ERROR_FIELD_ERROR_CATEGORY(0),
        HYPER_ERROR_FIELD_ERROR_CODE(1),
        HYPER_ERROR_FIELD_MESSAGE(2),
        HYPER_ERROR_FIELD_HINT_MESSAGE(3),
        HYPER_ERROR_FIELD_SEVERITY(4),
        HYPER_ERROR_FIELD_SQL_STATE(5),
        HYPER_ERROR_FIELD_CAUSE(6),
        HYPER_ERROR_FIELD_CONTEXT_ID(7);

        private final int value;

        private hyper_error_field_key(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

