/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Objects;

public final class Interval
implements Comparable<Interval> {
    private RawInterval rawInterval;
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private int microseconds;
    private boolean parsed = false;

    public Interval(int years, int months, int days, int hours, int minutes, int seconds, int microseconds) {
        this.rawInterval = Interval.getRawInterval(years, months, days, hours, minutes, seconds, microseconds);
    }

    Interval(RawInterval rawInterval) {
        this.rawInterval = rawInterval;
    }

    static RawInterval getRawInterval(int years, int months, int days, int hours, int minutes, int seconds, int microseconds) {
        long raw1 = (long)microseconds + 1000000L * (long)seconds + 60000000L * (long)minutes + 3600000000L * (long)hours;
        int monthsTotal = years * 12 + months;
        long raw2 = (long)monthsTotal << 32 | (long)days;
        return new RawInterval(raw1, raw2);
    }

    RawInterval getRaw() {
        return this.rawInterval;
    }

    public int getYears() {
        this.parse_if_necessary();
        return this.years;
    }

    public int getMonths() {
        this.parse_if_necessary();
        return this.months;
    }

    public int getDays() {
        this.parse_if_necessary();
        return this.days;
    }

    public int getHours() {
        this.parse_if_necessary();
        return this.hours;
    }

    public int getMinutes() {
        this.parse_if_necessary();
        return this.minutes;
    }

    public int getSeconds() {
        this.parse_if_necessary();
        return this.seconds;
    }

    public int getMicroseconds() {
        this.parse_if_necessary();
        return this.microseconds;
    }

    public String toString() {
        this.parse_if_necessary();
        double secondsWithFraction = (double)this.seconds + (double)this.microseconds / 1000000.0;
        return "P" + this.years + "Y" + this.months + "M" + this.days + "DT" + this.hours + "H" + this.minutes + "M" + new DecimalFormat("#.######").format(secondsWithFraction) + "S";
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Interval other = (Interval)that;
        return this.rawInterval.equals(other.rawInterval);
    }

    public int hashCode() {
        return Objects.hash(this.rawInterval);
    }

    @Override
    public int compareTo(Interval other) {
        return Comparator.comparing(interval -> interval.rawInterval).compare(this, other);
    }

    private void parse_if_necessary() {
        if (!this.parsed) {
            long time_signed = this.rawInterval.data1;
            boolean time_negative = time_signed < 0L;
            long time_abs = time_negative ? -1L * time_signed : time_signed;
            this.microseconds = (int)(time_abs % 1000000L);
            this.seconds = (int)((time_abs /= 1000000L) % 60L);
            this.minutes = (int)((time_abs /= 60L) % 60L);
            this.hours = (int)(time_abs / 60L);
            if (time_negative) {
                this.hours *= -1;
                this.minutes *= -1;
                this.seconds *= -1;
                this.microseconds *= -1;
            }
            int totalMonth = (int)(this.rawInterval.data2 >> 32);
            this.years = totalMonth / 12;
            this.months = totalMonth % 12;
            this.days = (int)this.rawInterval.data2;
        }
    }

    static final class RawInterval
    implements Comparable<RawInterval> {
        long data1;
        long data2;

        RawInterval(long data1, long data2) {
            this.data1 = data1;
            this.data2 = data2;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            RawInterval other = (RawInterval)that;
            return this.data1 == other.data1 && this.data2 == other.data2;
        }

        public int hashCode() {
            return Objects.hash(this.data1, this.data2);
        }

        @Override
        public int compareTo(RawInterval other) {
            return Comparator.comparing(interval -> interval.data2).thenComparing(interval -> interval.data1).compare(this, other);
        }
    }
}

