/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.tableau.hyperapi.DatabaseName;
import com.tableau.hyperapi.Name;
import com.tableau.hyperapi.SchemaName;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;

public final class TableName
implements Comparable<TableName> {
    private static Comparator<TableName> tableNameComparator = TableName.initTableNameComparator();
    public static Comparator<TableName> nullSafeTableNameComparator = Comparator.nullsFirst(TableName::compareTo);
    private Name tableName;
    private SchemaName schemaName;

    private static Comparator<TableName> initTableNameComparator() {
        return Comparator.comparing(name -> name.schemaName, SchemaName.nullSafeSchemaNameComparator).thenComparing(name -> name.tableName);
    }

    public TableName(Name tableName) {
        this.tableName = tableName;
    }

    public TableName(String tableName) {
        this(new Name(tableName));
    }

    public TableName(SchemaName schemaName, Name tableName) {
        this.tableName = tableName;
        this.schemaName = schemaName;
    }

    public TableName(SchemaName schemaName, String tableName) {
        this(schemaName, new Name(tableName));
    }

    public TableName(Name schemaName, Name tableName) {
        this(new SchemaName(schemaName), tableName);
    }

    public TableName(Name schemaName, String tableName) {
        this(new SchemaName(schemaName), new Name(tableName));
    }

    public TableName(String schemaName, String tableName) {
        this(new SchemaName(schemaName), new Name(tableName));
    }

    public TableName(String schemaName, Name tableName) {
        this(new SchemaName(schemaName), tableName);
    }

    public TableName(DatabaseName databaseName, Name schemaName, Name tableName) {
        this(new SchemaName(databaseName, schemaName), tableName);
    }

    public TableName(DatabaseName databaseName, Name schemaName, String tableName) {
        this(new SchemaName(databaseName, schemaName), new Name(tableName));
    }

    public TableName(DatabaseName databaseName, String schemaName, Name tableName) {
        this(new SchemaName(databaseName, schemaName), tableName);
    }

    public TableName(DatabaseName databaseName, String schemaName, String tableName) {
        this(new SchemaName(databaseName, schemaName), tableName);
    }

    public TableName(Name databaseName, Name schemaName, Name tableName) {
        this(new SchemaName(databaseName, schemaName), tableName);
    }

    public TableName(Name databaseName, Name schemaName, String tableName) {
        this(new SchemaName(databaseName, schemaName), new Name(tableName));
    }

    public TableName(Name databaseName, String schemaName, Name tableName) {
        this(new SchemaName(databaseName, schemaName), tableName);
    }

    public TableName(Name databaseName, String schemaName, String tableName) {
        this(new SchemaName(databaseName, schemaName), new Name(tableName));
    }

    public TableName(String databaseName, Name schemaName, Name tableName) {
        this(new SchemaName(databaseName, schemaName), tableName);
    }

    public TableName(String databaseName, Name schemaName, String tableName) {
        this(new SchemaName(databaseName, schemaName), tableName);
    }

    public TableName(String databaseName, String schemaName, Name tableName) {
        this(new SchemaName(databaseName, schemaName), tableName);
    }

    public TableName(String databaseName, String schemaName, String tableName) {
        this(new SchemaName(databaseName, schemaName), tableName);
    }

    public String toString() {
        if (this.schemaName != null) {
            return this.schemaName.toString() + "." + this.tableName.toString();
        }
        return this.tableName.toString();
    }

    public Name getName() {
        return this.tableName;
    }

    public Optional<SchemaName> getSchemaName() {
        return Optional.ofNullable(this.schemaName);
    }

    public Optional<DatabaseName> getDatabaseName() {
        return this.schemaName != null ? this.schemaName.getDatabaseName() : Optional.empty();
    }

    String getSchemaNameOrNull() {
        if (this.schemaName != null) {
            return this.schemaName.getName().getUnescaped();
        }
        return null;
    }

    String getDatabaseNameOrNull() {
        if (this.schemaName != null) {
            return this.schemaName.getDatabaseNameOrNull();
        }
        return null;
    }

    public boolean isFullyQualified() {
        return this.schemaName != null && this.schemaName.isFullyQualified();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof TableName) {
            TableName other = (TableName)that;
            return Objects.equals(this.schemaName, other.schemaName) && this.tableName.equals(other.tableName);
        }
        return false;
    }

    @Override
    public int compareTo(TableName other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        return tableNameComparator.compare(this, other);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }
}

