/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import com.sun.jna.Pointer;
import com.tableau.hyperapi.HyperAPI;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;

public final class HyperException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String mainMessage;
    private String hint;
    private ContextId contextId;
    private HyperException cause;
    private String sqlState;

    HyperException(String mainMessage, String hint, HyperException cause, ContextId id) {
        this.mainMessage = mainMessage;
        this.hint = hint;
        this.cause = cause;
        this.contextId = id;
    }

    HyperException(ContextId id) {
        this(null, null, null, id);
    }

    HyperException(Pointer handle) {
        try {
            if (handle == null) {
                throw new AssertionError((Object)"HyperException, native handle can not be null");
            }
            this.copyNativeError(handle, 0);
        }
        finally {
            HyperAPI.hyper_error_destroy(handle);
        }
    }

    private HyperException(Pointer handle, int depth) {
        this.copyNativeError(handle, depth);
    }

    private static HyperAPI.hyper_error_field_value getField(Pointer handle, HyperAPI.hyper_error_field_key key) {
        HyperAPI.hyper_error_field_value.ByReference fieldValue = new HyperAPI.hyper_error_field_value.ByReference();
        Pointer error = HyperAPI.hyper_error_get_field(handle, key.getValue(), fieldValue);
        if (error != null) {
            throw new InternalError("HyperException.getMessage()");
        }
        switch (fieldValue.discriminator) {
            case 0: {
                fieldValue.value.setType(Integer.TYPE);
                fieldValue.value.readField("integer");
                break;
            }
            case 1: {
                fieldValue.value.setType(String.class);
                fieldValue.value.readField("string");
                break;
            }
            case 2: {
                fieldValue.value.setType(Pointer.class);
                fieldValue.value.readField("pointer");
            }
        }
        return fieldValue;
    }

    private static int getIntField(Pointer handle, HyperAPI.hyper_error_field_key key) {
        HyperAPI.hyper_error_field_value fieldValue = HyperException.getField(handle, key);
        assert (fieldValue.discriminator == 0 || fieldValue.discriminator == 3);
        return fieldValue.value.integer;
    }

    private static String getStringField(Pointer handle, HyperAPI.hyper_error_field_key key) {
        HyperAPI.hyper_error_field_value fieldValue = HyperException.getField(handle, key);
        assert (fieldValue.discriminator == 1);
        assert (fieldValue.value.string != null);
        return fieldValue.value.string.isEmpty() ? null : fieldValue.value.string;
    }

    private static Pointer getPointerField(Pointer handle, HyperAPI.hyper_error_field_key key) {
        HyperAPI.hyper_error_field_value fieldValue = HyperException.getField(handle, key);
        assert (fieldValue.discriminator == 2);
        return fieldValue.value.pointer;
    }

    @Override
    public HyperException getCause() {
        return this.cause;
    }

    public String getMainMessage() {
        return this.mainMessage;
    }

    @Deprecated
    public String getErrorMessage() {
        return this.getMainMessage();
    }

    public String getHint() {
        return this.hint;
    }

    @Override
    public String getMessage() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        if (this.mainMessage != null) {
            writer.print(this.mainMessage.replace("\n", "\n\t"));
        }
        if (this.hint != null) {
            writer.print("\nHint: " + this.hint.replace("\n", "\n\t"));
        }
        writer.print("\nContext: 0x" + String.format("%02x", this.contextId.getValue()));
        if (this.cause != null) {
            writer.print("\n\nCAUSED BY:\n");
            writer.print(this.cause.getMessage());
        }
        return swriter.toString();
    }

    public ContextId getContextId() {
        return this.contextId;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    private void copyNativeError(Pointer handle, int depth) {
        if (depth >= 10) {
            throw new InternalError("HyperException: cause chain longer than 10 entries");
        }
        this.cause = null;
        Pointer causeHandle = HyperException.getPointerField(handle, HyperAPI.hyper_error_field_key.HYPER_ERROR_FIELD_CAUSE);
        if (causeHandle != null) {
            this.cause = new HyperException(causeHandle, depth + 1);
        }
        this.mainMessage = HyperException.getStringField(handle, HyperAPI.hyper_error_field_key.HYPER_ERROR_FIELD_MESSAGE);
        this.hint = HyperException.getStringField(handle, HyperAPI.hyper_error_field_key.HYPER_ERROR_FIELD_HINT_MESSAGE);
        this.contextId = new ContextId(HyperException.getIntField(handle, HyperAPI.hyper_error_field_key.HYPER_ERROR_FIELD_CONTEXT_ID));
        this.sqlState = HyperException.getStringField(handle, HyperAPI.hyper_error_field_key.HYPER_ERROR_FIELD_SQL_STATE);
    }

    public static final class ContextId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int value;

        public ContextId(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

