/*
 * Decompiled with CFR 0.152.
 */
package com.tableau.hyperapi;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

class HyperBinary {
    private static final long microsecondsPerDay = 86400000000L;

    HyperBinary() {
    }

    static int getRawDate(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        return day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
    }

    static int getRawDate(LocalDate value) {
        return HyperBinary.getRawDate(value.getYear(), value.getMonthValue(), value.getDayOfMonth());
    }

    static long getRawTime(int hour, int minute, int second, int microsecond) {
        return (long)microsecond + 1000000L * (long)second + 60000000L * (long)minute + 3600000000L * (long)hour;
    }

    static long getRawTime(LocalTime value) {
        return HyperBinary.getRawTime(value.getHour(), value.getMinute(), value.getSecond(), value.getNano() / 1000);
    }

    static long getRawTimestamp(int year, int month, int day, int hour, int minute, int second, int microsecond) {
        return (long)HyperBinary.getRawDate(year, month, day) * 86400000000L + HyperBinary.getRawTime(hour, minute, second, microsecond);
    }

    static long getRawTimestamp(LocalDateTime value) {
        return HyperBinary.getRawTimestamp(value.getYear(), value.getMonthValue(), value.getDayOfMonth(), value.getHour(), value.getMinute(), value.getSecond(), value.getNano() / 1000);
    }

    static LocalDate getLocalDate(int rawDate) {
        int a = rawDate + 32044;
        int b = (4 * a + 3) / 146097;
        int c = a - 146097 * b / 4;
        int d = (4 * c + 3) / 1461;
        int e = c - 1461 * d / 4;
        int m = (5 * e + 2) / 153;
        int day = e - (153 * m + 2) / 5 + 1;
        int month = m + 3 - 12 * (m / 10);
        int year = 100 * b + d + m / 10 - 4800;
        return LocalDate.of(year, month, day);
    }

    static LocalTime getLocalTime(long rawTime) {
        long time = rawTime;
        int microsecond = (int)(time % 1000000L);
        int second = (int)((time /= 1000000L) % 60L);
        int minute = (int)((time /= 60L) % 60L);
        int hour = (int)(time / 60L);
        return LocalTime.of(hour, minute, second, microsecond * 1000);
    }

    static LocalDateTime getLocalDateTime(long rawTimestamp) {
        LocalDate date = HyperBinary.getLocalDate((int)Long.divideUnsigned(rawTimestamp, 86400000000L));
        LocalTime time = HyperBinary.getLocalTime(Long.remainderUnsigned(rawTimestamp, 86400000000L));
        return LocalDateTime.of(date, time);
    }
}

