# Package configuration file of the Tableau Hyper API for C++.

if("${CMAKE_MAJOR_VERSION}.${CMAKE_MINOR_VERSION}" LESS 2.5)
   message(FATAL_ERROR "CMake >= 2.6.0 required")
endif()
cmake_policy(PUSH)
cmake_policy(VERSION 2.6)

include(CMakeFindDependencyMacro)
find_dependency(tableauhyperapi-c)

#----------------------------------------------------------------
# Generated CMake target import file.
#----------------------------------------------------------------

# Commands may need to know the format version.
set(CMAKE_IMPORT_FILE_VERSION 1)

# Protect against multiple inclusion, which would fail when already imported targets are added once more.
set(_targetsDefined)
set(_targetsNotDefined)
set(_expectedTargets)
foreach(_expectedTarget "Tableau::tableauhyperapi-cxx")
  list(APPEND _expectedTargets ${_expectedTarget})
  if(NOT TARGET ${_expectedTarget})
    list(APPEND _targetsNotDefined ${_expectedTarget})
  endif()
  if(TARGET ${_expectedTarget})
    list(APPEND _targetsDefined ${_expectedTarget})
  endif()
endforeach()
if("${_targetsDefined}" STREQUAL "${_expectedTargets}")
  unset(_targetsDefined)
  unset(_targetsNotDefined)
  unset(_expectedTargets)
  set(CMAKE_IMPORT_FILE_VERSION)
  cmake_policy(POP)
  return()
endif()
if(NOT "${_targetsDefined}" STREQUAL "")
  message(FATAL_ERROR "Some (but not all) targets in this export set were already defined.\nTargets Defined: ${_targetsDefined}\nTargets not yet defined: ${_targetsNotDefined}\n")
endif()
unset(_targetsDefined)
unset(_targetsNotDefined)
unset(_expectedTargets)


# Compute the installation prefix relative to this file.
# The file is located at ${_IMPORT_PREFIX}/share/cmake/tableauhyperapi-cxx-config.cmake
get_filename_component(_IMPORT_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(_IMPORT_PREFIX "${_IMPORT_PREFIX}" PATH)
get_filename_component(_IMPORT_PREFIX "${_IMPORT_PREFIX}" PATH)
if(_IMPORT_PREFIX STREQUAL "/")
  set(_IMPORT_PREFIX "")
endif()

# Create imported target Tableau::tableauhyperapi-cxx
add_library(Tableau::tableauhyperapi-cxx INTERFACE IMPORTED)


set(INTERFACE_SOURCES
    "${_IMPORT_PREFIX}/include/hyperapi/ByteSpan.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Catalog.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Connection.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/DatabaseName.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Date.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Endpoint.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/HyperException.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/HyperProcess.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/HyperServiceVersion.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Inserter.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Interval.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Name.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Numeric.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/OffsetTimestamp.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Result.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/ResultSchema.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/SchemaName.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Sql.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/SqlType.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/TableDefinition.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/TableName.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Time.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/Timestamp.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/hyperapi.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/ByteSpan.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Catalog.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Connection.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Date.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/HyperException.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/HyperProcess.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Inserter.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Interval.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Name.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Numeric.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/OffsetTimestamp.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Parameters.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Parameters.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Result.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/ResultSchema.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/SchemaName.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Sql.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/SqlType.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/TableDefinition.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/TableName.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Time.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/Timestamp.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/infra.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/optional.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/impl/string_view.impl.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/optional.hpp"
    "${_IMPORT_PREFIX}/include/hyperapi/string_view.hpp"
)

set_target_properties(Tableau::tableauhyperapi-cxx PROPERTIES
  INTERFACE_INCLUDE_DIRECTORIES "${_IMPORT_PREFIX}/include"
  INTERFACE_SOURCES "${INTERFACE_SOURCES}"
)

set_target_properties(Tableau::tableauhyperapi-cxx PROPERTIES INTERFACE_LINK_LIBRARIES 
  "Tableau::tableauhyperapi-c"
)



# Cleanup temporary variables.
set(_IMPORT_PREFIX)

# Loop over all imported files and verify that they actually exist
foreach(target ${_IMPORT_CHECK_TARGETS} )
  foreach(file ${_IMPORT_CHECK_FILES_FOR_${target}} )
    if(NOT EXISTS "${file}" )
      message(FATAL_ERROR "The imported target \"${target}\" references the file
   \"${file}\"
but this file does not exist.  Possible reasons include:
* The file was deleted, renamed, or moved to another location.
* An install or uninstall procedure did not complete successfully.
* The installation package was faulty and contained
   \"${CMAKE_CURRENT_LIST_FILE}\"
but not all the files it references.
")
    endif()
  endforeach()
  unset(_IMPORT_CHECK_FILES_FOR_${target})
endforeach()
unset(_IMPORT_CHECK_TARGETS)



# This file does not depend on other imported targets which have
# been exported from the same project but in a separate export set.

# Commands beyond this point should not need to know the version.
set(CMAKE_IMPORT_FILE_VERSION)
cmake_policy(POP)
