#ifndef TABLEAU_HYPER_IMPL_NAME_IMPL_HPP
#define TABLEAU_HYPER_IMPL_NAME_IMPL_HPP

#include <cassert>
#include <hyperapi/Name.hpp>
#include <hyperapi/Sql.hpp>
#include <hyperapi/impl/infra.hpp>
#include <string>

namespace hyperapi {
inline Name::Name(std::string name)
   : name_(hyperapi::escapeName(name)), unescaped_(std::move(name)) {
   HYPER_PRECONDITION_MSG(!this->unescaped_.empty(), "Name(std::string name) called with empty string");
}

namespace internal {
static std::string checkNameString(const char* name) {
   HYPER_PRECONDITION_MSG(name != nullptr, "Name(const char*) called with nullptr");
   return name;
}
}

inline Name::Name(const char* name) : Name(internal::checkNameString(name)) {}
}

namespace std {
/** Specialization of `std::hash` for `hyperapi::Name`. */
template <>
struct hash<hyperapi::Name> {
   /** Calculates the hash value of the given name. */
   size_t operator()(const hyperapi::Name& name) const noexcept { return hash<string>()(name.toString()); }
};
}
#endif
