/**
 * \file
 */

#ifndef TABLEAU_HYPER_ENDPOINT_HPP
#define TABLEAU_HYPER_ENDPOINT_HPP

#include <string>
#include <utility>

namespace hyperapi {

/// Describes a network endpoint at which a Hyper server is accessible.
class Endpoint final {
   public:
   /**
     * Creates an Endpoint from the given connection descriptor.
     *
     * The descriptor is expected to be a tableau IPC descriptor (e.g., tab.tcp://localhost:7483).
     * \param connectionDescriptor  The tableau IPC connection descriptor string
     * \param userAgent  A user agent string, which will be used in telemetry and logging.
     *                   Note: This string will be sent to Tableau as part of telemetry data.
     */
   Endpoint(std::string connectionDescriptor, std::string userAgent)
      : connectionDescriptor_(std::move(connectionDescriptor)), userAgent_(std::move(userAgent)) {
   }

   /**
     * Returns the connection descriptor.
     * \return The connection descriptor
     */
   const std::string& getConnectionDescriptor() const { return connectionDescriptor_; }

   /**
     * Returns the user agent.
     * \return The user agent
     */
   const std::string& getUserAgent() const { return userAgent_; }

   private:
   /// The connection descriptor
   std::string connectionDescriptor_;
   /// The user agent
   std::string userAgent_;
};
}

#endif
