/**
 * \file
 */

#ifndef TABLEAU_HYPER_SQL_HPP
#define TABLEAU_HYPER_SQL_HPP

#include "hyperapi/string_view.hpp"
#include <string>

namespace hyperapi {
/**
  * Escapes the given string for safe usage in SQL query or command strings as a string literal.
  * \param input  The string literal that should be escaped.
  * \throws bad_alloc in case of error
  * \return The escaped identifier.
  */
std::string escapeStringLiteral(string_view input);

/**
  * Escapes the given string for safe usage in SQL query or command strings as an identifier.
  * \param input  The identifier that should be escaped.
  * \throws bad_alloc in case of error
  * \return The escaped identifier.
  */
std::string escapeName(string_view input);
}
#include <hyperapi/impl/Sql.impl.hpp>
#endif
