/**
 * \file
 */

#ifndef TABLEAU_HYPER_HYPER_SERVICE_VERSION_HPP
#define TABLEAU_HYPER_HYPER_SERVICE_VERSION_HPP

#include <string>

namespace hyperapi {

/**
 * A Hyper Service version number of the form 'major.minor'.
 */
struct HyperServiceVersion final {
   /**
     * The major part of the version number.
     */
   uint32_t major;
   /**
     * The minor part of the version number.
     */
   uint32_t minor;

   /**
     * Get the string representation of the version number.
     * \return the HyperServiceVersion in the 'major.minor' format.
     */
   std::string toString() { return std::to_string(major) + "." + std::to_string(minor); }
};
}

#endif
